<div class="modal-header">
    <h5 class="modal-title h6">{{ translate('Deelgo member reviews') }}</h5>
    <button type="button" class="close" data-dismiss="modal">
    </button>
</div>

<div class="container">
    <div class="row sort-reviews">
        <div class="">
            <label for="">{{ translate('Sort by ') }}</label>
        </div>
        <div class="">
            <select class="form-control" name="" id="">
                <option value="highest_rated">{{ translate('The highest rating') }}</option>
                <option value="top_reviewer">{{ translate('Top contributors') }}</option>
                <option value="time">{{ translate('The latest') }}</option>
                <option value="helpfulness">{{ translate('The most useful') }}</option>
                <option value="lowest_rated">{{ translate('The lowest rated') }}</option>
            </select>
        </div>
    </div>

    <div class="verifcont d-flex">
        <div class="iconverif">
            <img src="{{ static_asset('assets/img/verif.png') }}">
        </div>
        <div class="iconverif-txt">
            <h3>{{ translate('Des Avis 100 % Authentiques et Vérifiés sur Deelgo') }}</h3>
            <p class="iconverif-txt-p">
                {{ translate('Chez Deelgo, nous plaçons la transparence et la confiance de nos utilisateurs au cœur de nos valeurs. C’est pourquoi tous les avis sur notre application sont rigoureusement vérifiés pour garantir qu’ils reflètent de réelles expériences d’utilisation.') }}
            </p>
        </div>
    </div>
</div>

@if ($review == null)
    <div class="container">
        <!-- Add new review -->
        <form action="{{ route('reviews.store') }}" method="POST">
            @csrf
            <input type="hidden" name="product_id" value="{{ $product->id }}">
            <div class="modal-body">
                <div class="form-group">
                    <label class="opacity-60">{{ translate('Product') }}</label>
                    <p>{{ $product->getTranslation('name') }}</p>
                </div>
                <!-- Rating -->
                <div class="form-group">
                    <label class="opacity-60">{{ translate('Rating') }}</label>
                    <br>

                    <div class="rating rating-input">
                        <label>
                            <input type="radio" name="rating" value="1" required>
                            <i class="las la-star"></i>
                        </label>
                        <label>
                            <input type="radio" name="rating" value="2">
                            <i class="las la-star"></i>
                        </label>
                        <label>
                            <input type="radio" name="rating" value="3">
                            <i class="las la-star"></i>
                        </label>
                        <label>
                            <input type="radio" name="rating" value="4">
                            <i class="las la-star"></i>
                        </label>
                        <label>
                            <input type="radio" name="rating" value="5">
                            <i class="las la-star"></i>
                        </label>
                    </div>
                </div>
                <!-- Comment -->
                <div class="form-group">
                    <label class="opacity-60">{{ translate('Comment') }}</label>
                    <textarea class="form-control rounded-0" rows="4" name="comment" placeholder="{{ translate('Your review') }}"
                        required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="cancelbtn btn btn-sm btn-secondary rounded-0"
                    data-dismiss="modal">{{ translate('Cancel') }}</button>
                <button type="submit"
                    class="btn btn-sm btn-primary rounded-0 submitbtn ">{{ translate('Submit Review') }}</button>
            </div>
        </form>
    </div>
@endif


<div class="pb-3 pt-0 reviews-area">
    <ul class="list-group list-group-flush">
        @foreach ($product->reviews as $key => $review)
            @if ($review->user != null)
                <li class="media list-group-item d-flex px-3 px-md-4 border-0">
                    <div class="media-body text-left">
                        <!-- Review User Name -->
                        <!-- Review User Image -->
                        <div class="d-flex reviewrowflex">
                            <span class="avatar avatar-md mr-3">
                                <img class="lazyload" src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                    onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';"
                                    @if ($review->user->avatar_original != null) data-src="{{ uploaded_asset($review->user->avatar_original) }}"
                        @else
                            data-src="{{ static_asset('assets/img/placeholder.jpg') }}" @endif>
                            </span>
                            <div>
                                <h3 class="fs-15 fw-600 mb-0">{{ $review->user->name }}
                                </h3>
                                <!-- Variation -->
                                @php
                                    $OrderDetail = get_order_details_by_review($review);
                                @endphp
                                @if ($OrderDetail && $OrderDetail->variation)
                                    <small class="text-secondary fs-12">{{ translate('Variation :') }}
                                        {{ $OrderDetail->variation }}</small>
                                @endif
                            </div>
                        </div>
                        <div class="d-flex starsholder">
                            <!-- Review ratting -->
                            <span class="rating rating-mr-2">
                                @for ($i = 0; $i < $review->rating; $i++)
                                    <i class="las la-star active"></i>
                                @endfor
                                @for ($i = 0; $i < 5 - $review->rating; $i++)
                                    <i class="las la-star"></i>
                                @endfor
                            </span>
                            <!-- Review Date -->
                            <div class="datereview">
                                . {{ date('d-m-Y', strtotime($review->created_at)) }}
                            </div>
                        </div>
                        <!-- Review Comment -->
                        <p class="comment-text mb-0 mt-0 fs-14">
                            {{ $review->comment }}
                        </p>
                        <p class="comment-date">
                            {{ translate('Used') }} : {{ date('d-m-Y', strtotime($review->created_at)) }}
                        </p>
                    </div>
                </li>
            @endif
        @endforeach
    </ul>
    @if (count($product->reviews) <= 0)
        <div class="text-center fs-18 opacity-70">
            {{ translate('There have been no reviews for this product yet.') }}
        </div>
    @endif
</div>
