<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\ShopController;
use App\Http\Controllers\SubscriberController;
use App\Http\Controllers\ContactController;

/*
|--------------------------------------------------------------------------
| CSRF Token Refresh Route
|--------------------------------------------------------------------------
|
| A simple route to refresh and return the CSRF token.
|
*/
Route::get('/refresh-csrf', function () {
    return csrf_token();
});
/*
|--------------------------------------------------------------------------
| Home and Frontend Routes
|--------------------------------------------------------------------------
|
| Routes that handle the landing page, home page sections, login/registration,
| product details, shops, policies, order tracking, and other frontend pages.
|
*/
Route::controller(HomeController::class)->group(function () {
    // Landing page and home
    Route::get('/', 'landingpage')->name('home');
});
/*
|--------------------------------------------------------------------------
| Utility Routes
|--------------------------------------------------------------------------
|
| Routes for language switching, currency switching, size charts, and sitemap.
|
*/
Route::post('/language', [LanguageController::class, 'changeLanguage'])->name('language.change');

Route::resource('shops', ShopController::class)->middleware('handle-demo-login');
/*
|--------------------------------------------------------------------------
| Subscriber Routes
|--------------------------------------------------------------------------
*/
Route::resource('subscribers', SubscriberController::class);
Route::get('unsubscribe', [SubscriberController::class, 'unsubscribe'])->name('subscribers.unsubscribe');
/*
|--------------------------------------------------------------------------
| Miscellaneous Routes
|--------------------------------------------------------------------------
*/
// Translation check
Route::get('translation-check/{check}', [LanguageController::class, 'get_translation']);
/*
|--------------------------------------------------------------------------
| Contact Routes
|--------------------------------------------------------------------------
*/
Route::controller(ContactController::class)->prefix('contact')->group(function () {
    Route::get('/', 'index')->name('contact.index');
    Route::post('process', 'process')->name('contact.process');
    Route::post('process_contact_form', 'process_contact_form')->name('contact.process_contact_form');
    Route::post('process_propose_deal_form', 'process_propose_deal_form')->name('contact.process_propose_deal_form');
    Route::post('process_propose_event_form', 'process_propose_event_form')->name('contact.process_propose_event_form');
    Route::post('careers_form', 'process_careers_form')->name('contact.careers_form');
});
/*
|--------------------------------------------------------------------------
| Custom Pages and Profile Routes
|--------------------------------------------------------------------------
*/
Route::controller(PageController::class)->group(function () {
    // Mobile app blank page for webview
    Route::get('/mobile-page/{slug}', 'mobile_custom_page')->name('mobile.custom-pages');
    // Custom pages
    Route::get('/{slug}', 'show_custom_page')->name('custom-pages.show_custom_page');
});

