<?php
    $advantages = [
        [
            'icon' => 'assets/img/choices.webp',
            'title' => translate('Find What Interests You'),
            'description' => translate(
                'Browse a wide selection of events and exclusive offers. Whether it’s for an unforgettable concert, an intense football match, or a gastronomic experience at a reduced price, everything is within your reach.',
            ),
        ],
        [
            'icon' => 'assets/img/online-shopping.webp',
            'title' => translate('Book & Buy Securely'),
            'description' => translate(
                'Select your favorite event or deal, confirm your order in just a few seconds, and enjoy secure payment.',
            ),
        ],
        [
            'icon' => 'assets/img/online-ticket.webp',
            'title' => translate('Receive Your Confirmation Instantly'),
            'description' =>
                translate('Once your purchase is completed:') .
                '<ul>
                <li>' .
                translate('Event Ticket: Received directly by email or available in your customer area.') .
                '</li>
                <li>' .
                translate('Deal & Offer: Access your voucher immediately, ready to be used.') .
                '</li>
            </ul>',
        ],
        [
            'icon' => 'assets/img/lecture-room.webp',
            'title' => translate('Enjoy to the Fullest!Enjoy to the Fullest!'),
            'description' =>
                '
                <ul>
                    <li>' .
                translate('Attend your event without stress and live unique moments.') .
                '</li>
                    <li>' . translate('Use your voucher to enjoy the best experiences at reduced prices.') . '</li>
                </ul>
            ',
        ],
    ];
?>

<div id="landingpage-advantages" class="section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6 pullright">
<div class="wolholder">
                <h2><?php echo e(translate('How Does It Work?')); ?></h2>
                <p><?php echo e(translate('Simple, Rapide et Efficace !')); ?></p>

                <ul class="mlist">
                    <li><?php echo e(translate('Infoline')); ?> : <a href="tel:+212630063006">+2126 30 06 30 06</a></li>
                    <li><?php echo e(translate('Email')); ?> : <a href="mailto:contact@deelgo.com">contact@deelgo.com</a></li>
                </ul>

</div>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <?php $__currentLoopData = $advantages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $advantage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6">
                            <div class="info-box">
                                <div class="info-box-top">
                                    <div class="d-flex"> 
                                    <span class="adv-title"><?php echo e($advantage['title']); ?></span></div>
                                </div>
                                <div class="info-box-content">
                                    <?php echo $advantage['description']; ?>

                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/deelgo/public_html/resources/views/frontend/landingpage/partials/advantages.blade.php ENDPATH**/ ?>