<?php $__env->startSection('meta_title'); ?><?php echo e($page->meta_title); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('meta_description'); ?><?php echo e($page->meta_description); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('meta_keywords'); ?><?php echo e($page->tags); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="<?php echo e($page->meta_title); ?>">
    <meta itemprop="description" content="<?php echo e($page->meta_description); ?>">
    <meta itemprop="image" content="<?php echo e(uploaded_asset($page->meta_image)); ?>">

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="website">
    <meta name="twitter:site" content="@publisher_handle">
    <meta name="twitter:title" content="<?php echo e($page->meta_title); ?>">
    <meta name="twitter:description" content="<?php echo e($page->meta_description); ?>">
    <meta name="twitter:creator" content="@author_handle">
<meta name="twitter:image" content="<?php echo e(uploaded_asset($page->meta_image)); ?>">

<!-- Open Graph data -->
<meta property="og:title" content="<?php echo e($page->meta_title); ?>" />
<meta property="og:type" content="website" />
<meta property="og:url" content="<?php echo e(URL($page->slug)); ?>" />
<meta property="og:image" content="<?php echo e(uploaded_asset($page->meta_image)); ?>" />
<meta property="og:description" content="<?php echo e($page->meta_description); ?>" />
<meta property="og:site_name" content="<?php echo e(env('APP_NAME')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul
                    class="product-breadcrumb breadcrumb align-items-baseline justify-content-center justify-content-lg-start bg-transparent p-0">
                    <li class="breadcrumb-item has-transition opacity-60 hov-opacity-100">
                        <a class="text-reset" href="<?php echo e(route('home')); ?>"><?php echo e(translate('Home')); ?></a>
                    </li>
                    <li class="breadcrumb-item">
                        <span><?php echo e($page->getTranslation('title')); ?></span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row">
            <?php if('' != $page->form): ?>
            <div class="col-md-6">
                <?php echo $__env->make('frontend.forms.' . $page->form, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <?php endif; ?>

            <div class="col  <?php if('' == $page->form): ?> bg-white p-5 mb-4 <?php endif; ?>">
                <div class="page-content">
                    <?php echo $page->getTranslation('content'); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php if(get_setting('google_recaptcha') == 1): ?>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php endif; ?>

<script type="text/javascript">
    <?php if(get_setting('google_recaptcha') == 1): ?>
        // making the CAPTCHA  a required field for form submission
        $(document).ready(function () {
            $("#reg-form").on("submit", function (evt) {
                var response = grecaptcha.getResponse();
                if (response.length == 0) {
                    //reCaptcha not verified
                    alert("please verify you are human!");
                    evt.preventDefault();
                    return false;
                }
                //captcha verified
                //do the rest of your validations here
                $("#reg-form").submit();
            });
        }); <?php endif; ?>
        </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/deelgo/public_html/resources/views/frontend/pages/index.blade.php ENDPATH**/ ?>