<div class="page-form">
    <div class="page-form-inner">
        <form id="reg-form" class="form-default" role="form" action="<?php echo e(route('shops.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="row">
                <div class="col-md-12">
                    <h2><?php echo e(translate('Boost your sales with deelgo')); ?></h2>
                    <p><?php echo e(translate('Start today with no upfront costs!')); ?></p>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    
                    <div class="form-group">
                        <label for="last_name"><?php echo e(translate('Last Name')); ?></label>
                        <input type="text" id="last_name"
                            class="form-control rounded-0<?php echo e($errors->has('last_name') ? ' is-invalid' : ''); ?>"
                            value="<?php echo e(old('last_name')); ?>" placeholder="<?php echo e(translate('Last Name')); ?>" name="last_name"
                            required>
                        <?php if($errors->has('last_name')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('last_name')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-6">
                    
                    <div class="form-group">
                        <label for="first_name"><?php echo e(translate('First Name')); ?></label>
                        <input type="text" id="first_name"
                            class="form-control rounded-0<?php echo e($errors->has('first_name') ? ' is-invalid' : ''); ?>"
                            value="<?php echo e(old('first_name')); ?>" placeholder="<?php echo e(translate('First Name')); ?>"
                            name="first_name" required>
                        <?php if($errors->has('first_name')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('first_name')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    
                    <div class="form-group">
                        <label for="company_name"><?php echo e(translate('Company Name')); ?></label>
                        <input type="text" id="company_name"
                            class="form-control rounded-0<?php echo e($errors->has('company_name') ? ' is-invalid' : ''); ?>"
                            value="<?php echo e(old('company_name')); ?>" placeholder="<?php echo e(translate('Company Name')); ?>"
                            name="company_name" required>
                        <?php if($errors->has('company_name')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('company_name')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-6">
                    
                    <div class="form-group">
                        <label for="category"><?php echo e(translate('Category')); ?></label>
                        <select name="category" id="category"
                            class="form-control rounded-0<?php echo e($errors->has('category') ? ' is-invalid' : ''); ?>" required>
                            <option value=""><?php echo e(translate('Choose category')); ?></option>
                            <?php $__currentLoopData = get_parent_categories(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('category')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('category')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    
                    <div class="form-group">
                        <label for="phone"><?php echo e(translate('Phone')); ?></label>
                        <input type="tel" id="phone"
                            class="form-control rounded-0<?php echo e($errors->has('phone') ? ' is-invalid' : ''); ?>"
                            value="<?php echo e(old('phone')); ?>" placeholder="<?php echo e(translate('Phone')); ?>" name="phone"
                            required>
                        <?php if($errors->has('phone')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('phone')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-6">
                    
                    <div class="form-group">
                        <label for="email"><?php echo e(translate('Email')); ?></label>
                        <input type="email" id="email"
                            class="form-control rounded-0<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>"
                            value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(translate('Email')); ?>" name="email"
                            required>
                        <?php if($errors->has('email')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('email')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    
                    <div class="form-group">
                        <label for="address"><?php echo e(translate('Address')); ?></label>
                        <input type="text" id="address"
                            class="form-control rounded-0<?php echo e($errors->has('address') ? ' is-invalid' : ''); ?>"
                            value="<?php echo e(old('address')); ?>" placeholder="<?php echo e(translate('Address')); ?>" name="address"
                            required>
                        <?php if($errors->has('address')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('address')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-6">
                    
                    <div class="form-group">
                        <label for="city"><?php echo e(translate('City')); ?></label>
                        <input type="text"
                            class="form-control rounded-0<?php echo e($errors->has('city') ? ' is-invalid' : ''); ?>"
                            value="<?php echo e(old('city')); ?>" placeholder="<?php echo e(translate('City')); ?>" name="city" required>
                        <?php if($errors->has('city')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('city')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Recaptcha -->
            <?php if(get_setting('google_recaptcha') == 1): ?>
                <div class="form-group">
                    <div class="g-recaptcha" data-sitekey="<?php echo e(env('CAPTCHA_KEY')); ?>">
                    </div>
                </div>
                <?php if($errors->has('g-recaptcha-response')): ?>
                    <span class="invalid-feedback" role="alert" style="display: block;">
                        <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                    </span>
                <?php endif; ?>
            <?php endif; ?>

            <!-- Submit Button -->
            <div class="mb-4 mt-4">
                <button type="submit"
                    class="btn btn-primary btn-block fw-600 rounded-0"><?php echo e(translate('Register Your Shop')); ?></button>
            </div>
        </form>
    </div>
</div>
<?php /**PATH /home/deelgo/public_html/resources/views/frontend/forms/espace_pro_form.blade.php ENDPATH**/ ?>