<!-- Top Bar Banner -->
<?php
    $topbar_banner = get_setting('topbar_banner');
    $topbar_banner_medium = get_setting('topbar_banner_medium');
    $topbar_banner_small = get_setting('topbar_banner_small');
    $topbar_banner_asset = uploaded_asset($topbar_banner);
?>
<?php if($topbar_banner != null): ?>
    <div class="position-relative top-banner removable-session z-1035 d-none" data-key="top-banner" data-value="removed">
        <a href="<?php echo e(get_setting('topbar_banner_link')); ?>" class="d-block text-reset h-40px h-lg-60px">
            <!-- For Large device -->
            <img src="<?php echo e($topbar_banner_asset); ?>" class="d-none d-xl-block img-fit h-100"
                alt="<?php echo e(translate('topbar_banner')); ?>">
            <!-- For Medium device -->
            <img src="<?php echo e($topbar_banner_medium != null ? uploaded_asset($topbar_banner_medium) : $topbar_banner_asset); ?>"
                class="d-none d-md-block d-xl-none img-fit h-100" alt="<?php echo e(translate('topbar_banner')); ?>">
            <!-- For Small device -->
            <img src="<?php echo e($topbar_banner_small != null ? uploaded_asset($topbar_banner_small) : $topbar_banner_asset); ?>"
                class="d-md-none img-fit h-100" alt="<?php echo e(translate('topbar_banner')); ?>">
        </a>
        <button class="btn text-white h-100 absolute-top-right set-session" data-key="top-banner" data-value="removed"
            data-toggle="remove-parent" data-parent=".top-banner">
            <i class="la la-close la-2x"></i>
        </button>
    </div>
<?php endif; ?>
<!-- Top Bar -->

<header class="<?php if(get_setting('header_stikcy') == 'on'): ?> sticky-top <?php endif; ?> z-1020 bg-white">
    <!-- Search Bar -->
    <div class="position-relative logo-bar-area border-bottom border-md-nonea z-1025">
        <div class="container">
            <div class="d-flex align-items-center">
                <!-- top menu sidebar button -->
                <button type="button" id="mobile-megamenu-toggle-btn" class="btn d-lg-none mr-3 mr-sm-4 p-0 active">
                    <svg id="Component_43_1" data-name="Component 43 – 1" xmlns="http://www.w3.org/2000/svg"
                        width="16" height="16" viewBox="0 0 16 16">
                        <rect id="Rectangle_19062" data-name="Rectangle 19062" width="16" height="2"
                            transform="translate(0 7)" fill="#919199" />
                        <rect id="Rectangle_19063" data-name="Rectangle 19063" width="16" height="2"
                            fill="#919199" />
                        <rect id="Rectangle_19064" data-name="Rectangle 19064" width="16" height="2"
                            transform="translate(0 14)" fill="#919199" />
                    </svg>
                </button>
                <!-- Header Logo -->
                <div class="col-auto pl-0 pr-3 d-flex align-items-center">
                    <a class="d-block py-10px mr-3 ml-0" href="<?php echo e(route('home')); ?>">
                        <?php
                            $header_logo = get_setting('header_logo');
                        ?>
                        <?php if($header_logo != null): ?>
                            <img src="<?php echo e(uploaded_asset($header_logo)); ?>" alt="<?php echo e(env('APP_NAME')); ?>"
                                class="mw-100 h-60px h-md-60px" height="40">
                        <?php else: ?>
                            <img src="<?php echo e(static_asset('assets/img/logo.png')); ?>" alt="<?php echo e(env('APP_NAME')); ?>"
                                class="mw-100 h-30px h-md-40px" height="40">
                        <?php endif; ?>
                    </a>
                </div>

                <!-- Search Icon for small device -->
                <div class="d-none ml-auto mr-0">
                    <a class="d-block text-reset" href="javascript:void(0);" data-toggle="class-toggle"
                        data-target=".front-header-search">
                        <i class="las la-search la-flip-horizontal la-2x"></i>
                    </a>
                </div>
                <!-- Search field -->
                <div class="flex-grow-1 front-header-search d-flex align-items-center bg-white">
                    <div class="position-relative flex-grow-1 px-3 px-lg-0">
                        <form action="" method="GET" class="stop-propagation">
                            <div class="d-flex position-relative align-items-center">
                                <div class="d-lg-none" data-toggle="class-toggle" data-target=".front-header-search">
                                    <button class="btn px-2" type="button"><i
                                            class="la la-2x la-long-arrow-left"></i></button>
                                </div>
                                <div id="megamenu-toggle-btn" class="burgermenu">
                                    <img class="headerburger" src="<?php echo e(static_asset('assets/img/headerburger.webp')); ?>">
                                </div>
                                <div class="search-input-box">
                                    <input type="text"
                                        class="border border-soft-light form-control fs-14 hov-animate-outline"
                                        id="search" name="keyword"
                                        <?php if(isset($query)): ?>
                                        value="<?php echo e($query); ?>"
                                    <?php endif; ?>
                                        placeholder="<?php echo e(translate('I am shopping for...')); ?>" autocomplete="off">
                                    <button class="btn search-btn" type="submit">
                                        <svg id="Group_723" data-name="Group 723" xmlns="http://www.w3.org/2000/svg"
                                            width="20.001" height="20" viewBox="0 0 20.001 20">
                                            <path id="Path_3090" data-name="Path 3090"
                                                d="M9.847,17.839a7.993,7.993,0,1,1,7.993-7.993A8,8,0,0,1,9.847,17.839Zm0-14.387a6.394,6.394,0,1,0,6.394,6.394A6.4,6.4,0,0,0,9.847,3.453Z"
                                                transform="translate(-1.854 -1.854)" fill="#b5b5bf"></path>
                                            <path id="Path_3091" data-name="Path 3091"
                                                d="M24.4,25.2a.8.8,0,0,1-.565-.234l-6.15-6.15a.8.8,0,0,1,1.13-1.13l6.15,6.15A.8.8,0,0,1,24.4,25.2Z"
                                                transform="translate(-5.2 -5.2)" fill="#b5b5bf"></path>
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </form>
                        <div class="typed-search-box stop-propagation document-click-d-none d-none bg-white rounded shadow-lg position-absolute left-0 top-100 w-100"
                            style="min-height: 200px">
                            <div class="search-preloader absolute-top-center">
                                <div class="dot-loader">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>
                            </div>
                            <div class="search-nothing d-none p-3 text-center fs-16">
                            </div>
                            <div id="search-content" class="text-left">
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Search box -->
                <div class="d-none d-lg-none ml-3 mr-0">
                    <div class="nav-search-box">
                        <a href="#" class="nav-box-link">
                            <i class="la la-search la-flip-horizontal d-inline-block nav-box-icon"></i>
                        </a>
                    </div>
                </div>

                <div class="d-none d-xl-block mr-0 ml-4 hovermenu-toggle" style="position:relative">
                    <?php if(auth()->guard()->check()): ?>
                        <span
                            class="d-flex align-items-center nav-user-info py-20px <?php if(isAdmin()): ?> ml-5 <?php endif; ?>"
                            id="nav-user-info">
                            <!-- Image -->
                            <span class="  overflow-hidden border border-transparent nav-user-img">
                                <?php if($user->avatar_original != null): ?>
                                    <img src="<?php echo e($user_avatar); ?>" class="img-fit h-100"
                                        alt="<?php echo e(translate('avatar')); ?>"
                                        onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/avatar-place.png')); ?>';">
                                <?php else: ?>
                                    <img src="<?php echo e(static_asset('assets/img/avatar-place.png')); ?>" class="image"
                                        alt="<?php echo e(translate('avatar')); ?>"
                                        onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/avatar-place.png')); ?>';">
                                <?php endif; ?>
                            </span>
                            <!-- Name -->
                            <h4 class="h5 fs-14 fw-700 text-dark ml-2 mb-0"><?php echo e($user->name); ?></h4>
                        </span>
                    <?php else: ?>
                        <!--Login & Registration -->
                        <a href="#" class="text-reset ">
                            <span class="d-flex align-items-center nav-user-info ">
                                <!-- Image -->
                                <span
                                    class="  overflow-hidden d-flex align-items-center justify-content-center nav-user-img">
                                    <img src="<?php echo e(static_asset('assets/img/account.webp')); ?>">
                                </span>
                                <div class="logininfos">
                                    <?php echo e(translate('Login')); ?>

                                </div>
                            </span>
                        </a>
                    <?php endif; ?>
                    <?php if(auth()->guard()->check()): ?>
                        <div class="hover-user-top-menu position-absolute top-100 left-0 right-0 z-3">
                            <div class="container">
                                <div class="position-static float-right">
                                    <div class="aiz-user-top-menu bg-white rounded-0 border-top shadow-sm"
                                        style="width:220px;">
                                        <ul class="list-unstyled no-scrollbar mb-0 text-left">
                                            <?php if(isAdmin()): ?>
                                                <li class="user-top-nav-element border border-top-0" data-id="1">
                                                    <a href="<?php echo e(route('admin.dashboard')); ?>"
                                                        class="text-truncate text-dark px-4 fs-14 d-flex align-items-center hov-column-gap-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                            height="16" viewBox="0 0 16 16">
                                                            <path id="Path_2916" data-name="Path 2916"
                                                                d="M15.3,5.4,9.561.481A2,2,0,0,0,8.26,0H7.74a2,2,0,0,0-1.3.481L.7,5.4A2,2,0,0,0,0,6.92V14a2,2,0,0,0,2,2H14a2,2,0,0,0,2-2V6.92A2,2,0,0,0,15.3,5.4M10,15H6V9A1,1,0,0,1,7,8H9a1,1,0,0,1,1,1Zm5-1a1,1,0,0,1-1,1H11V9A2,2,0,0,0,9,7H7A2,2,0,0,0,5,9v6H2a1,1,0,0,1-1-1V6.92a1,1,0,0,1,.349-.76l5.74-4.92A1,1,0,0,1,7.74,1h.52a1,1,0,0,1,.651.24l5.74,4.92A1,1,0,0,1,15,6.92Z"
                                                                fill="#b5b5c0" />
                                                        </svg>
                                                        <span
                                                            class="user-top-menu-name has-transition ml-3"><?php echo e(translate('Dashboard')); ?></span>
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                            <?php if(isCustomer()): ?>
                                                <li class="user-top-nav-element border border-top-0" data-id="1">
                                                    <a href="<?php echo e(route('purchase_history.index')); ?>"
                                                        class="text-truncate text-dark px-4 fs-14 d-flex align-items-center hov-column-gap-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                            height="16" viewBox="0 0 16 16">
                                                            <g id="Group_25261" data-name="Group 25261"
                                                                transform="translate(-27.466 -542.963)">
                                                                <path id="Path_2953" data-name="Path 2953"
                                                                    d="M14.5,5.963h-4a1.5,1.5,0,0,0,0,3h4a1.5,1.5,0,0,0,0-3m0,2h-4a.5.5,0,0,1,0-1h4a.5.5,0,0,1,0,1"
                                                                    transform="translate(22.966 537)" fill="#b5b5bf" />
                                                                <path id="Path_2954" data-name="Path 2954"
                                                                    d="M12.991,8.963a.5.5,0,0,1,0-1H13.5a2.5,2.5,0,0,1,2.5,2.5v10a2.5,2.5,0,0,1-2.5,2.5H2.5a2.5,2.5,0,0,1-2.5-2.5v-10a2.5,2.5,0,0,1,2.5-2.5h.509a.5.5,0,0,1,0,1H2.5a1.5,1.5,0,0,0-1.5,1.5v10a1.5,1.5,0,0,0,1.5,1.5h11a1.5,1.5,0,0,0,1.5-1.5v-10a1.5,1.5,0,0,0-1.5-1.5Z"
                                                                    transform="translate(27.466 536)" fill="#b5b5bf" />
                                                                <path id="Path_2955" data-name="Path 2955"
                                                                    d="M7.5,15.963h1a.5.5,0,0,1,.5.5v1a.5.5,0,0,1-.5.5h-1a.5.5,0,0,1-.5-.5v-1a.5.5,0,0,1,.5-.5"
                                                                    transform="translate(23.966 532)" fill="#b5b5bf" />
                                                                <path id="Path_2956" data-name="Path 2956"
                                                                    d="M7.5,21.963h1a.5.5,0,0,1,.5.5v1a.5.5,0,0,1-.5.5h-1a.5.5,0,0,1-.5-.5v-1a.5.5,0,0,1,.5-.5"
                                                                    transform="translate(23.966 529)" fill="#b5b5bf" />
                                                                <path id="Path_2957" data-name="Path 2957"
                                                                    d="M7.5,27.963h1a.5.5,0,0,1,.5.5v1a.5.5,0,0,1-.5.5h-1a.5.5,0,0,1-.5-.5v-1a.5.5,0,0,1,.5-.5"
                                                                    transform="translate(23.966 526)" fill="#b5b5bf" />
                                                                <path id="Path_2958" data-name="Path 2958"
                                                                    d="M13.5,16.963h5a.5.5,0,0,1,0,1h-5a.5.5,0,0,1,0-1"
                                                                    transform="translate(20.966 531.5)" fill="#b5b5bf" />
                                                                <path id="Path_2959" data-name="Path 2959"
                                                                    d="M13.5,22.963h5a.5.5,0,0,1,0,1h-5a.5.5,0,0,1,0-1"
                                                                    transform="translate(20.966 528.5)" fill="#b5b5bf" />
                                                                <path id="Path_2960" data-name="Path 2960"
                                                                    d="M13.5,28.963h5a.5.5,0,0,1,0,1h-5a.5.5,0,0,1,0-1"
                                                                    transform="translate(20.966 525.5)" fill="#b5b5bf" />
                                                            </g>
                                                        </svg>
                                                        <span
                                                            class="user-top-menu-name has-transition ml-3"><?php echo e(translate('Purchase History')); ?></span>
                                                    </a>
                                                </li>
                                                <li class="user-top-nav-element border border-top-0" data-id="1">
                                                    <a href="<?php echo e(route('digital_purchase_history.index')); ?>"
                                                        class="text-truncate text-dark px-4 fs-14 d-flex align-items-center hov-column-gap-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16.001"
                                                            height="16" viewBox="0 0 16.001 16">
                                                            <g id="Group_25262" data-name="Group 25262"
                                                                transform="translate(-1388.154 -562.604)">
                                                                <path id="Path_2963" data-name="Path 2963"
                                                                    d="M77.864,98.69V92.1a.5.5,0,1,0-1,0V98.69l-1.437-1.437a.5.5,0,0,0-.707.707l1.851,1.852a1,1,0,0,0,.707.293h.172a1,1,0,0,0,.707-.293l1.851-1.852a.5.5,0,0,0-.7-.713Z"
                                                                    transform="translate(1318.79 478.5)" fill="#b5b5bf" />
                                                                <path id="Path_2964" data-name="Path 2964"
                                                                    d="M67.155,88.6a3,3,0,0,1-.474-5.963q-.009-.089-.015-.179a5.5,5.5,0,0,1,10.977-.718,3.5,3.5,0,0,1-.989,6.859h-1.5a.5.5,0,0,1,0-1l1.5,0a2.5,2.5,0,0,0,.417-4.967.5.5,0,0,1-.417-.5,4.5,4.5,0,1,0-8.908.866.512.512,0,0,1,.009.121.5.5,0,0,1-.52.479,2,2,0,1,0-.162,4l.081,0h2a.5.5,0,0,1,0,1Z"
                                                                    transform="translate(1324 486)" fill="#b5b5bf" />
                                                            </g>
                                                        </svg>
                                                        <span
                                                            class="user-top-menu-name has-transition ml-3"><?php echo e(translate('Downloads')); ?></span>
                                                    </a>
                                                </li>
                                                <?php if(get_setting('conversation_system') == 1): ?>
                                                    <li class="user-top-nav-element border border-top-0" data-id="1">
                                                        <a href="<?php echo e(route('conversations.index')); ?>"
                                                            class="text-truncate text-dark px-4 fs-14 d-flex align-items-center hov-column-gap-1">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                                height="16" viewBox="0 0 16 16">
                                                                <g id="Group_25263" data-name="Group 25263"
                                                                    transform="translate(1053.151 256.688)">
                                                                    <path id="Path_3012" data-name="Path 3012"
                                                                        d="M134.849,88.312h-8a2,2,0,0,0-2,2v5a2,2,0,0,0,2,2v3l2.4-3h5.6a2,2,0,0,0,2-2v-5a2,2,0,0,0-2-2m1,7a1,1,0,0,1-1,1h-8a1,1,0,0,1-1-1v-5a1,1,0,0,1,1-1h8a1,1,0,0,1,1,1Z"
                                                                        transform="translate(-1178 -341)"
                                                                        fill="#b5b5bf" />
                                                                    <path id="Path_3013" data-name="Path 3013"
                                                                        d="M134.849,81.312h8a1,1,0,0,1,1,1v5a1,1,0,0,1-1,1h-.5a.5.5,0,0,0,0,1h.5a2,2,0,0,0,2-2v-5a2,2,0,0,0-2-2h-8a2,2,0,0,0-2,2v.5a.5.5,0,0,0,1,0v-.5a1,1,0,0,1,1-1"
                                                                        transform="translate(-1182 -337)"
                                                                        fill="#b5b5bf" />
                                                                    <path id="Path_3014" data-name="Path 3014"
                                                                        d="M131.349,93.312h5a.5.5,0,0,1,0,1h-5a.5.5,0,0,1,0-1"
                                                                        transform="translate(-1181 -343.5)"
                                                                        fill="#b5b5bf" />
                                                                    <path id="Path_3015" data-name="Path 3015"
                                                                        d="M131.349,99.312h5a.5.5,0,1,1,0,1h-5a.5.5,0,1,1,0-1"
                                                                        transform="translate(-1181 -346.5)"
                                                                        fill="#b5b5bf" />
                                                                </g>
                                                            </svg>
                                                            <span
                                                                class="user-top-menu-name has-transition ml-3"><?php echo e(translate('Conversations')); ?></span>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if(get_setting('wallet_system') == 1): ?>
                                                    <li class="user-top-nav-element border border-top-0" data-id="1">
                                                        <a href="<?php echo e(route('wallet.index')); ?>"
                                                            class="text-truncate text-dark px-4 fs-14 d-flex align-items-center hov-column-gap-1">
                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                xmlns:xlink="http://www.w3.org/1999/xlink" width="16"
                                                                height="16" viewBox="0 0 16 16">
                                                                <defs>
                                                                    <clipPath id="clip-path1">
                                                                        <rect id="Rectangle_1386"
                                                                            data-name="Rectangle 1386" width="16"
                                                                            height="16" fill="#b5b5bf" />
                                                                    </clipPath>
                                                                </defs>
                                                                <g id="Group_8102" data-name="Group 8102"
                                                                    clip-path="url(#clip-path1)">
                                                                    <path id="Path_2936" data-name="Path 2936"
                                                                        d="M13.5,4H13V2.5A2.5,2.5,0,0,0,10.5,0h-8A2.5,2.5,0,0,0,0,2.5v11A2.5,2.5,0,0,0,2.5,16h11A2.5,2.5,0,0,0,16,13.5v-7A2.5,2.5,0,0,0,13.5,4M2.5,1h8A1.5,1.5,0,0,1,12,2.5V4H2.5a1.5,1.5,0,0,1,0-3M15,11H10a1,1,0,0,1,0-2h5Zm0-3H10a2,2,0,0,0,0,4h5v1.5A1.5,1.5,0,0,1,13.5,15H2.5A1.5,1.5,0,0,1,1,13.5v-9A2.5,2.5,0,0,0,2.5,5h11A1.5,1.5,0,0,1,15,6.5Z"
                                                                        fill="#b5b5bf" />
                                                                </g>
                                                            </svg>
                                                            <span
                                                                class="user-top-menu-name has-transition ml-3"><?php echo e(translate('My Wallet')); ?></span>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                                <li class="user-top-nav-element border border-top-0" data-id="1">
                                                    <a href="<?php echo e(route('support_ticket.index')); ?>"
                                                        class="text-truncate text-dark px-4 fs-14 d-flex align-items-center hov-column-gap-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                            height="16.001" viewBox="0 0 16 16.001">
                                                            <g id="Group_25259" data-name="Group 25259"
                                                                transform="translate(-316 -1066)">
                                                                <path id="Subtraction_184" data-name="Subtraction 184"
                                                                    d="M16427.109,902H16420a8.015,8.015,0,1,1,8-8,8.278,8.278,0,0,1-1.422,4.535l1.244,2.132a.81.81,0,0,1,0,.891A.791.791,0,0,1,16427.109,902ZM16420,887a7,7,0,1,0,0,14h6.283c.275,0,.414,0,.549-.111s-.209-.574-.34-.748l0,0-.018-.022-1.064-1.6A6.829,6.829,0,0,0,16427,894a6.964,6.964,0,0,0-7-7Z"
                                                                    transform="translate(-16096 180)" fill="#b5b5bf" />
                                                                <path id="Union_12" data-name="Union 12"
                                                                    d="M16414,895a1,1,0,1,1,1,1A1,1,0,0,1,16414,895Zm.5-2.5V891h.5a2,2,0,1,0-2-2h-1a3,3,0,1,1,3.5,2.958v.54a.5.5,0,1,1-1,0Zm-2.5-3.5h1a.5.5,0,1,1-1,0Z"
                                                                    transform="translate(-16090.998 183.001)"
                                                                    fill="#b5b5bf" />
                                                            </g>
                                                        </svg>
                                                        <span
                                                            class="user-top-menu-name has-transition ml-3"><?php echo e(translate('Support Ticket')); ?></span>
                                                    </a>
                                                </li>
                                            <?php endif; ?>

                                            <li class="user-top-nav-element border border-top-0" data-id="1">
                                                <a href="<?php echo e(route('logout')); ?>"
                                                    class="text-truncate text-dark px-4 fs-14 d-flex align-items-center hov-column-gap-1">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16"
                                                        height="15.999" viewBox="0 0 16 15.999">
                                                        <g id="Group_25503" data-name="Group 25503"
                                                            transform="translate(-24.002 -377)">
                                                            <g id="Group_25265" data-name="Group 25265"
                                                                transform="translate(-216.534 -160)">
                                                                <path id="Subtraction_192" data-name="Subtraction 192"
                                                                    d="M12052.535,2920a8,8,0,0,1-4.569-14.567l.721.72a7,7,0,1,0,7.7,0l.721-.72a8,8,0,0,1-4.567,14.567Z"
                                                                    transform="translate(-11803.999 -2367)"
                                                                    fill="#d43533" />
                                                            </g>
                                                            <rect id="Rectangle_19022" data-name="Rectangle 19022"
                                                                width="1" height="8" rx="0.5"
                                                                transform="translate(31.5 377)" fill="#d43533" />
                                                        </g>
                                                    </svg>
                                                    <span
                                                        class="user-top-menu-name text-primary has-transition ml-3"><?php echo e(translate('Logout')); ?></span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <a href="" class="d-flex align-items-center text-dark px-0 h-100">
                    <div class="d-flex flexcart heartico ml-4 flexcartfav align-items-center ">
                        <span class=" text-center">
                            <img class="carticon" src="<?php echo e(static_asset('assets/img/favori.webp')); ?>">
                        </span>
                        <span class="cart-items-count"><?php echo e(get_wishlists()->count()); ?></span>
                        <div class="cartsinfo">
                            <span class="listedefavori  nav-box-text d-none d-xl-block ml-2">
                                <?php echo e(translate('Wishlist')); ?>

                            </span>
                        </div>
                    </div>
                </a>
                <div class="ml-4 d-none cartmobile d-xl-block has-transition " data-hover="dropdown">
                    <div class="nav-cart-box dropdown h-100" id="cart_items" style="width: max-content;">

                    </div>
                </div>
            </div>
        </div>
        <!-- Loged in user Menus -->
    </div>
    <!-- Menu Bar -->
    <div class="d-none position-relative h-50px">
        <div class="container h-100">
            <div class="d-flex h-100">
                <!-- Categoty Menu Button -->
                <?php
                    $nav_txt_color =
                        get_setting('header_nav_menu_text') == 'light' || get_setting('header_nav_menu_text') == null
                            ? 'text-white'
                            : 'text-dark';

                ?>
                <div class="ml-xl-4 w-100 overflow-hidden">
                    <div class="d-flex align-items-center justify-content-center h-100">
                        <ul class="list-inline mb-0 pl-0 hor-swipe c-scrollbar-light">
                            <?php $__currentLoopData = get_categories(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-inline-item mr-0 animate-underline-white">
                                    <span
                                        class="fs-15 px-3 py-2 d-inline-block fw-400 <?php echo e($nav_txt_color); ?> header_menu_links hov-bg-black-10">
                                        <?php echo e($category->getTranslation('name')); ?>

                                    </span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-inline-item mr-0 animate-underline-white">
                                <span
                                    class="fs-15 px-3 py-2 d-inline-block fw-400 <?php echo e($nav_txt_color); ?> header_menu_links hov-bg-black-10">
                                    <?php echo e(translate('Promotions')); ?>

                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

<!-- Modal -->
<div class="modal fade" id="order_details" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div id="order-details-modal-body">
            </div>
        </div>
    </div>
</div>
<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/deelgo/public_html/resources/views/frontend/inc/nav.blade.php ENDPATH**/ ?>