<?php

namespace Tests\Unit;

use Tests\TestCase;
use App\Services\OneSignalService;
use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Response;
use GuzzleHttp\Exception\RequestException;
use Mockery;

/**
 * Unit tests for the OneSignalService class.
 */
class OneSignalServiceTest extends TestCase
{
    /**
     * Test sending a notification successfully.
     *
     * @return void
     */
    public function testSendNotificationSuccess()
    {
        $mockClient = Mockery::mock(Client::class);
        $mockResponse = new Response(200, [], json_encode(['id' => 'notification-id']));

        $mockClient->shouldReceive('post')->once()->andReturn($mockResponse);

        $this->app->instance(Client::class, $mockClient);

        $service = new OneSignalService();
        $result = $service->sendNotification('Test Title', 'Test Message', 'https://deelgo.prowebplanners.com/', 'https://deelgo.prowebplanners.com/image.png');

        $this->assertEquals('notification-id', $result['id']);
    }

    /**
     * Test handling a failed notification.
     *
     * @return void
     */
    public function testSendNotificationFailure()
    {
        $mockClient = Mockery::mock(Client::class);
        $mockClient->shouldReceive('post')->once()->andThrow(new RequestException('Error', new \GuzzleHttp\Psr7\Request('POST', 'test')));

        $this->app->instance(Client::class, $mockClient);

        $service = new OneSignalService();
        $result = $service->sendNotification('Test Title', 'Test Message');

        $this->assertFalse($result);
    }
}
